//effect.js
//Effects system.


//INTEGER EFFECTS
//Effects that can be used anywhere where integers are required.


function IntegerEffect(type, time, maxvalue)
{
	this.type = type;
	this.time = time;		//Amount of times the function will be run before the end result is achieved.
	this.currenttime = 0;
	this.maxvalue = maxvalue;
	this.value = 0;
	
	this.init = function()
	{
		if (this.type == "fade out")
			this.value = this.maxvalue,
			this.stepamount = this.maxvalue/this.time;  //Amount to use per step.
		
		else if (this.type == "fade in")
			this.value = 0,
			this.stepamount = this.maxvalue/this.time;  //Amount to use per step.
	}
	
	this.update = function()
	{
		if (this.type == "fade out")
		{
			this.value -= this.stepamount;
			return this.value;
		}
		
		else if (this.type == "fade in")
		{
			this.value += this.stepamount;
			return this.value;
		}
	}
}